#!/usr/bin/env python
# -*- coding: utf-8 -*-
import argparse


def args_parser():
    parser = argparse.ArgumentParser()
    # federated arguments (Notation for the arguments followed from paper)
    parser.add_argument('--b',type=float,default=0.01,help='b')
    parser.add_argument('--beta',type=float,default=0,help='privacy')
    parser.add_argument('--epochs', type=int, default=500,
                        help="number of rounds of training")
    parser.add_argument('--num_users', type=int, default=100,
                        help="number of users: K")
    parser.add_argument('--frac', type=float, default=1,
                        help='reporting probability p')
    parser.add_argument('--local_ep', type=int, default=1,
                        help="the number of local epochs: E")
    parser.add_argument('--local_bs', type=int, default=256,
                        help="local batch size")
    parser.add_argument('--lr', type=float, default=0.01,
                        help='learning rate')
    parser.add_argument('--weight_decay', type=float, default=0,
                        help='decay rate')
    parser.add_argument('--momentum', type=float, default=0,
                        help='SGD momentum')

    # model arguments
    parser.add_argument('--model', type=str, default='mlp', help='mlp|model name')
    parser.add_argument('--kernel_num', type=int, default=9,
                        help='number of each kind of kernel')
    parser.add_argument('--kernel_sizes', type=str, default='3,4,5',
                        help='comma-separated kernel size to \
                        use for convolution')
    parser.add_argument('--num_channels', type=int, default=1, help="number \
                        of channels of imgs")
    parser.add_argument('--norm', type=str, default='batch_norm',
                        help="batch_norm, layer_norm, or None")
    parser.add_argument('--num_filters', type=int, default=32,
                        help="number of filters for conv nets -- 32 for \
                        mini-imagenet, 64 for omiglot.")
    parser.add_argument('--max_pool', type=str, default='True',
                        help="Whether use max pooling rather than \
                        strided convolutions")
    parser.add_argument('--dim_hidden', type=int, default=64,
                        help='dim_hidden')

    # other arguments
    parser.add_argument('--dataset', type=str, default='mnist', help="name \
                        of dataset")
    parser.add_argument('--num_classes', type=int, default=10, help="number \
                        of classes")
    parser.add_argument('--gpu', default='cuda:0', help="To use cuda, set \
                        to a specific GPU ID. Default set to use CPU.")
    parser.add_argument('--optimizer', type=str, default='sgd', help="type \
                        of optimizer")
    parser.add_argument('--iid', type=int, default=0,
                        help='Default set to IID. Set to 0 for non-IID.')
    parser.add_argument('--alpha',type=float,default=1,help='dirichlet parameter')
    parser.add_argument('--verbose', type=int, default=0, help='verbose')
    parser.add_argument('--seed', type=int, default=1, help='random seed')
    parser.add_argument('--class_per_user', type=int, default=1, help="class_per_user")
    parser.add_argument('--mode', type=str, default='STO-SIGNSGD', help="SIGNSGD|STO-SIGNSGD|FedAvg")
    parser.add_argument('--Byzantine', type=float, default=0.0,
                        help='Byzantine')
    parser.add_argument('--gamma', type=int, default=1,
                    help='scheduler ratio')  
    parser.add_argument('--weighted', type=int, default=0,
                        help='Byzantine')  
    parser.add_argument('--adaptive', type=int, default=1,
                        help='Byzantine')                   
    args = parser.parse_args()
    return args
